#---------------------------------------------
# R script to run EVA 
# Update input parameters below in section EVA parameters
# 
#---------------------------------------------

# Set the working directory
setwd("/.../...")

# Load Eva functions - (change path if not in current working directory)
source("/.../EvaR_Functions.R")


# Set default parameters for EVA
EvaSetDefaultParameters()

# Save parameterfile to file
EvaSaveParameterFile("EvaParm.Rda")

# Read parameterfile from file
EvaLoadParameterFile("EvaParm.Rda")

#------------------------------------
# EVA parameters
#------------------------------------

# examples of changing parameter values
EvaParm$DataParameters$ResultsDirectory <- "t_"
EvaParm$OCSParameters$w_merit <- 1.0
EvaParm$OCSParameters$w_relationship <- -50
EvaParm$OCSParameters$Nmatings <- 200
EvaParm$DataParameters$DataFile <- "evapig.dat"
EvaParm$RelationsMatrix$source <- "file"
EvaParm$RelationsMatrix$Gfile <- "Gmatrix.dat"

#------------------------------------
# Run EVA
#------------------------------------

# Run EVA
EvaRun()

#------------------------------------
# Output
#------------------------------------

# view eva.log
EvaLog()

# view F_summary file
EvaSummary()

# load all available parameter files into memory
EvaLoadResultFiles()

# plot convergence
EvaPlotConvergence()

# plot results (examples of plots focusing on getting an overview)
EvaPlotResults()

# plots 1 to N is produced, plotX
# view plot1
plot1

